<?php
// ====== SIMPLE PASSWORD LOGIN (tanpa DB) ======
session_start();
$ADMIN_PASS = 'ibitek2026'; // Ganti sesuai keinginan

// Logout (opsional via URL)
if (isset($_GET['logout'])) {
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params["path"], $params["domain"],
      $params["secure"], $params["httponly"]
    );
  }
  session_destroy();
  header('Location: list_mahasiswa.php');
  exit;
}

// Proses submit password
$login_error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['admin_pass'])) {
  $pass = (string)($_POST['admin_pass'] ?? '');
  if (hash_equals($ADMIN_PASS, $pass)) {
    $_SESSION['ktm_admin'] = true;
    // Balik ke halaman utama (jaga-jaga tetap di list)
    header('Location: list_mahasiswa.php');
    exit;
  } else {
    $login_error = 'Password salah.';
  }
}

// Jika belum login: tampilkan form login lalu stop
if (empty($_SESSION['ktm_admin'])):
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login Admin KTM</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
  body{min-height:100vh;display:flex;align-items:center;justify-content:center;background:#f5f7fb}
  .card{max-width:380px;width:100%}
</style>
</head>
<body>
  <div class="card shadow-sm">
    <div class="card-body">
        <div class="navbar-brand d-flex align-items-center gap-2" href="#top">
            <span><img src="assets/img/logo_kampus.png" style="width:60px;"></span>
        <span><img src="assets/img/logo_ibitek.png" style="width:45px;"></span>
        
       
      </div>
      <hr>
      <?php if ($login_error): ?>
        <div class="alert alert-danger py-2"><?= htmlspecialchars($login_error) ?></div>
      <?php endif; ?>
      <form method="post" action="">
        <div class="mb-3">
          <label class="form-label">Password</label>
          <input type="password" name="admin_pass" class="form-control" required autofocus>
        </div>
        <button class="btn btn-primary w-100" type="submit">Masuk</button>
      </form>
      <div class="form-text mt-3">
        * Login hanya untuk ADMIN!.
      </div>
    </div>
  </div>
</body>
</html>
<?php
exit; // stop di sini kalau belum login
endif;
// ====== END SIMPLE LOGIN ======
?>

<?php
require __DIR__ . '/koneksi.php';

/* ====== Search & Pagination ====== */
$perPage = 15;
$page = max(1, (int)($_GET['page'] ?? 1));
$qstr = trim($_GET['q'] ?? '');

$where = '';
if ($qstr !== '') {
  $qs = $conn->real_escape_string($qstr);
  $where = "WHERE nama LIKE '%$qs%' OR nim LIKE '%$qs%' OR jurusan LIKE '%$qs%'";
}

$cntRes = $conn->query("SELECT COUNT(*) AS c FROM mahasiswa $where");
$total  = (int)($cntRes ? ($cntRes->fetch_assoc()['c'] ?? 0) : 0);
$pages  = max(1, (int)ceil($total / $perPage));
$page   = min($page, $pages);
$offset = ($page - 1) * $perPage;

/* dataset untuk tabel (desktop) */
$q = $conn->query("SELECT * FROM mahasiswa $where ORDER BY tanggal DESC, id DESC LIMIT $offset, $perPage");
/* dataset untuk kartu (mobile) – query yang sama agar tidak mengganggu loop tabel */
$qm = $conn->query("SELECT * FROM mahasiswa $where ORDER BY tanggal DESC, id DESC LIMIT $offset, $perPage");

/* ====== Buat URL WhatsApp share form ====== */
$baseFormUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http')
  . '://' . $_SERVER['HTTP_HOST']
  . rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\') . '/form.php';

$waText = rawurlencode(
  "Halo,\nSilakan isi Form KTM IBITEK melalui tautan berikut:\n$baseFormUrl\n\nTerima kasih."
);
$waUrl = "https://wa.me/?text={$waText}";
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Daftar Mahasiswa</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
  /* gaya kecil untuk kartu di HP */
  @media (max-width: 767.98px){
    .mhs-card img.mhs-photo{
      width:72px;height:72px;object-fit:cover;border-radius:10px;
      background:#f2f2f2;
    }
    .mhs-meta{ font-size:.9rem }
    .mhs-nim code{ font-size:.9rem }
  }
</style>
</head>
<body class="bg-light">
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <span><img src="assets/img/logo_kampus.png" style="width:60px;"></span>
    <div class="d-flex gap-2">
  <a href="<?= $waUrl ?>" target="_blank" class="btn btn-success">WA</a>
  <a href="form.php" class="btn btn-primary">+ Buat KTM</a>
  <a href="list_mahasiswa.php?logout=1" class="btn btn-danger" title="Keluar">Logout</a>
</div>

  </div>

  <!-- Search -->
  <form class="row g-2 mb-3" method="get">
    <div class="col-sm-6 col-md-5 col-lg-4">
      <input type="text" name="q" value="<?= htmlspecialchars($qstr) ?>" class="form-control"
             placeholder="Cari nama / NIM / jurusan">
    </div>
    <div class="col-auto">
      <button class="btn btn-outline-secondary" type="submit">Search</button>
      <?php if ($qstr !== ''): ?>
        <a class="btn btn-outline-dark" href="list_mahasiswa.php">Reset</a>
      <?php endif; ?>
    </div>
  </form>

  <div class="card shadow-sm">
    <!-- ====== LIST MODE CARD (HP) ====== -->
    <div class="d-md-none p-2">
      <?php if ($qm && $qm->num_rows): while ($r = $qm->fetch_assoc()): ?>
        <div class="mhs-card card mb-2">
          <div class="card-body d-flex gap-3 align-items-start">
            <?php if(!empty($r['foto'])): ?>
              <img src="<?= htmlspecialchars($r['foto']) ?>" alt="foto" class="mhs-photo">
            <?php else: ?>
              <div class="mhs-photo d-flex align-items-center justify-content-center bg-light border" style="width:72px;height:72px;border-radius:10px;">No Foto</div>
            <?php endif; ?>
            <div class="flex-fill">
              <div class="fw-bold"><?= htmlspecialchars($r['nama']) ?></div>
              <div class="text-muted mhs-meta">
                <?= htmlspecialchars($r['jenjang']) ?> • <?= htmlspecialchars($r['jurusan']) ?> • <?= htmlspecialchars($r['angkatan']) ?>
              </div>
              <div class="mhs-nim">NIM: <code><?= htmlspecialchars($r['nim']) ?></code></div>
              <div class="small text-muted"><?= htmlspecialchars($r['tanggal']) ?></div>
              <div class="mt-2 d-flex flex-wrap gap-2">
                <a class="btn btn-outline-secondary btn-sm" href="edit_mahasiswa.php?id=<?= (int)$r['id'] ?>">Edit</a>
                <form method="post" action="delete_mahasiswa.php" onsubmit="return confirm('Hapus data ini?');" class="m-0">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <button class="btn btn-outline-danger btn-sm" type="submit">Hapus</button>
                </form>
                <a class="btn btn-primary btn-sm" target="_blank" href="make_pdf.php?id=<?= (int)$r['id'] ?>">Buat KTM PDF</a>
              </div>
            </div>
          </div>
        </div>
      <?php endwhile; else: ?>
        <div class="text-center text-muted py-4">Belum ada data.</div>
      <?php endif; ?>
    </div>

    <!-- ====== TABEL (DESKTOP) ====== -->
    <div class="table-responsive d-none d-md-block">
      <table class="table table-sm align-middle m-0">
        <thead class="table-light">
          <tr>
            <th width="60">Foto</th>
            <th>Nama</th>
            <th>Jenjang</th>
            <th>Jurusan</th>
            <th>Angkatan</th>
            <th>NIM</th>
            <th>Tanggal</th>
            <th width="210">Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($q && $q->num_rows): while($r=$q->fetch_assoc()): ?>
            <tr>
              <td><?php if(!empty($r['foto'])): ?><img src="<?= htmlspecialchars($r['foto']) ?>" style="height:46px;border-radius:6px"><?php endif; ?></td>
              <td><?= htmlspecialchars($r['nama']) ?></td>
              <td><?= htmlspecialchars($r['jenjang']) ?></td>
              <td><?= htmlspecialchars($r['jurusan']) ?></td>
              <td><?= htmlspecialchars($r['angkatan']) ?></td>
              <td><code><?= htmlspecialchars($r['nim']) ?></code></td>
              <td><?= htmlspecialchars($r['tanggal']) ?></td>
              <td class="d-flex gap-1">
                <a class="btn btn-outline-secondary btn-sm" href="edit_mahasiswa.php?id=<?= (int)$r['id'] ?>">Edit</a>
                <form method="post" action="delete_mahasiswa.php" onsubmit="return confirm('Hapus data ini?');">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <button class="btn btn-outline-danger btn-sm" type="submit">Hapus</button>
                </form>
                <a class="btn btn-success btn-sm" target="_blank" href="make_pdf.php?id=<?= (int)$r['id'] ?>">Buat KTM PDF</a>
              </td>
            </tr>
          <?php endwhile; else: ?>
            <tr><td colspan="8" class="text-center text-muted py-4">Belum ada data.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <!-- Pagination (muncul untuk semua ukuran layar) -->
    <?php
      $start = $total ? ($offset + 1) : 0;
      $end   = min($offset + $perPage, $total);
      $window = 2;
      $startPage = max(1, $page - $window);
      $endPage   = min($pages, $page + $window);
      $qsBase = $qstr !== '' ? '&q=' . urlencode($qstr) : '';
    ?>
    <div class="d-flex justify-content-between align-items-center p-3">
      <div class="small text-muted">
        Menampilkan <?= $start ?>–<?= $end ?> dari <?= $total ?> data.
      </div>
      <?php if ($pages > 1): ?>
      <nav>
        <ul class="pagination pagination-sm mb-0">
          <li class="page-item <?= $page<=1?'disabled':'' ?>">
            <a class="page-link" href="?page=<?= max(1,$page-1).$qsBase ?>">«</a>
          </li>
          <?php if ($startPage > 1): ?>
            <li class="page-item"><a class="page-link" href="?page=1<?= $qsBase ?>">1</a></li>
            <?php if ($startPage > 2): ?><li class="page-item disabled"><span class="page-link">…</span></li><?php endif; ?>
          <?php endif; ?>
          <?php for($p=$startPage;$p<=$endPage;$p++): ?>
            <li class="page-item <?= $p==$page?'active':'' ?>">
              <a class="page-link" href="?page=<?= $p.$qsBase ?>"><?= $p ?></a>
            </li>
          <?php endfor; ?>
          <?php if ($endPage < $pages): ?>
            <?php if ($endPage < $pages-1): ?><li class="page-item disabled"><span class="page-link">…</span></li><?php endif; ?>
            <li class="page-item"><a class="page-link" href="?page=<?= $pages.$qsBase ?>"><?= $pages ?></a></li>
          <?php endif; ?>
          <li class="page-item <?= $page>=$pages?'disabled':'' ?>">
            <a class="page-link" href="?page=<?= min($pages,$page+1).$qsBase ?>">»</a>
          </li>
        </ul>
      </nav>
      <?php endif; ?>
    </div>
  </div>
</div>
</body>
</html>
