<?php /* Variabel tersedia:
$nama,$jenjang,$jurusan,$angkatan,$nim,$frontBg,$backBg,$photo,$barcode
*/ ?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<style>
  @page { size: 54mm 86mm; margin: 0; }
  html,body { margin:0; padding:0; }
  .page { width:54mm; height:86mm; position:relative; overflow:hidden; page-break-after: always; }
  .page.back { page-break-after: auto; }

  .bg    { position:absolute; left:0; top:0; width:54mm; height:86mm; }
  .name  { position:absolute; left:10mm; right:6mm; top:19mm;
           text-align:left; font-family:'Arial',Helvetica,sans-serif;
           font-weight:700; font-size:4.5mm; color:#ffffff; }
  .photo { position:absolute; left:16.45mm; top:27.8mm; width:34.4mm; height:43mm;
           object-fit:cover; border-radius:0 0 2mm 0; }
  .barcode { position:absolute; left:34.8mm; bottom:7.4mm; width:14.8mm; height:auto; }
  .nimbox  { position:absolute; left:32mm; bottom:1.2mm; padding:.8mm 2mm;
             font-family:'Arial',Helvetica,sans-serif; font-weight:700;
             font-size:3mm; background:transparent; border-radius:1mm; }
</style>
</head>
<body>

<!-- FRONT -->
<div class="page front">
  <?php if (!empty($frontBg)): ?>
    <img class="bg" src="<?= $frontBg ?>" alt="front background">
  <?php else: ?>
    <div class="bg" style="background:#0f3565;"></div>
  <?php endif; ?>

  <div class="name"><?= htmlspecialchars($nama) ?></div>
  <img class="photo"   src="<?= $photo   ?>" alt="photo">
  <img class="barcode" src="<?= $barcode ?>" alt="barcode">
  <div class="nimbox"><?= htmlspecialchars($nim) ?></div>
</div>

<!-- BACK -->
<?php
  // Paksa fallback ke file lokal jika $backBg kosong
  $__backSrc = $backBg ?? '';
  if (!$__backSrc) {
    $__abs = realpath(__DIR__ . '/../assets/backs/back_template_belakang.png');
    if ($__abs) { $__backSrc = 'file://' . $__abs; }
  }
?>
<div class="page back">
  <?php if (!empty($__backSrc)): ?>
    <img class="bg" src="<?= $__backSrc ?>" alt="back background">
  <?php else: ?>
    <div class="bg" style="background:#0f3565;"></div>
  <?php endif; ?>
</div>

</body>
</html>
